if (!requireNamespace("BiocManager", quietly = TRUE))
  install.packages("BiocManager")

BiocManager::install("systemPipeR")

library(systemPipeR)
library(ggplot2)
library(DESeq2)


## Polysomal RNA analysis with gene and TE seperation ##


coldata <- DataFrame(assay=factor(rep(c("Mpoly","Total"), each=6)), condition=factor(rep(c("ddm1rdr6", "ddm1rdr6", "ddm1rdr6","ddm1", "ddm1", "ddm1")), levels=c("ddm1rdr6", "ddm1")), row.names=c("Mpoly_ddm1rdr6_1", "Mpoly_ddm1rdr6_2", "Mpoly_ddm1rdr6_3", "Mpoly_ddm1_1", "Mpoly_ddm1_2", "Mpoly_ddm1_3", "Total_ddm1rdr6_1", "Total_ddm1rdr6_2", "Total_ddm1rdr6_3", "Total_ddm1_1", "Total_ddm1_2", "Total_ddm1_3"))

countDFeByg <- read.delim("unscaled_Mpoly_gene_final.txt", header=TRUE, sep="\t", row.names=1)

dds2 <- DESeqDataSetFromMatrix(countData=countDFeByg, colData = coldata, design = ~ assay + condition + assay:condition)
dds2 <- DESeq(dds2, test="LRT", reduced = ~ assay + condition)
res2 <- DESeq2::results(dds2)

library(EnhancedVolcano)
png("M poly gene ddm1rdr6 vs ddm1.png", width = 7, height = 6, units = 'in', res = 300)
EnhancedVolcano(res2,
                lab = rownames(res2),
                x = 'log2FoldChange',
                y = 'pvalue',
                xlim = c(-12, 12),
                ylim = c(0, 6),
                selectLab = c('AT5G60450'),
                title = 'M poly gene ddm1rdr6 vs ddm1',
                pCutoff = 0.01,
                FCcutoff = 0.5,
                col=c('grey30','grey30','grey30','red2'),
                transcriptPointSize = 1.5,
                transcriptLabSize = 0)


dev.off()

pdf("M poly gene ddm1rdr6 vs ddm1.pdf", width = 7, height = 6)
EnhancedVolcano(res2,
                lab = rownames(res2),
                x = 'log2FoldChange',
                y = 'pvalue',
                xlim = c(-12, 12),
                ylim = c(0, 6),
                selectLab = c('AT5G60450'),
                title = 'M poly gene ddm1rdr6 vs ddm1',
                pCutoff = 0.01,
                FCcutoff = 0.5,
                col=c('grey30','grey30','grey30','red2'),
                transcriptPointSize = 1.5,
                transcriptLabSize = 0)


dev.off()

head(res2[order(res2$padj),],4)
write.table(res2, file="transleff_Mpoly_gene.xls", quote=FALSE, col.names = NA, sep="\t")


countDFeByg <- read.delim("unscaled_Mpoly_TE_gene_final.txt", header=TRUE, sep="\t", row.names=1)

dds_M_TE <- DESeqDataSetFromMatrix(countData=countDFeByg, colData = coldata, design = ~ assay + condition + assay:condition)
dds_M_TE <- DESeq(dds_M_TE, test="LRT", reduced = ~ assay + condition)
res_M_TE <- DESeq2::results(dds_M_TE)

athila <- c('AT4G03825', 'AT3G33124', 'AT1G42360', 'AT5G32197', 'AT5G32228', 'AT5G31719', 'AT5G29975', 'AT3G33067', 'AT5G32306', 'AT5G32517', 'AT5G32107', 'AT1G37015', 'AT5G32143', 'AT5G31804', 'AT5G32161', 'AT2G10280', 'AT4G06517', 'AT1G37867', 'AT4G06712', 'AT4G06664', 'AT4G03860', 'AT4G06710', 'AT3G33091', 'AT5G31999', 'AT4G06656', 'AT3G30825', 'AT3G33058')

keyvals <- rep('grey30', nrow(res_M_TE))

names(keyvals) <- rep('Non', nrow(res_M_TE))

keyvals[which((res_M_TE$log2FoldChange > 0.5 & res_M_TE$pvalue < 0.01) | (res_M_TE$log2FoldChange < -0.5 & res_M_TE$pvalue < 0.01))] <- 'red2'

names(keyvals)[which((res_M_TE$log2FoldChange > 0.5 & res_M_TE$pvalue < 0.01) | (res_M_TE$log2FoldChange < -0.5 & res_M_TE$pvalue < 0.01))] <- 'Significant'


keyvals[which(rownames(res_M_TE) %in% athila)] <- 'blue'

names(keyvals)[which(rownames(res_M_TE) %in% athila)] <- 'ATHILA'


png("M poly TE ddm1rdr6 vs ddm1_Athila.png", width = 7, height = 6, units = 'in', res = 300)

EnhancedVolcano(res_M_TE,
                lab = rownames(res_M_TE),
                x = 'log2FoldChange',
                y = 'pvalue',
                xlim = c(-12, 12),
                ylim = c(0, 6),
                colCustom = keyvals,
                title = 'M poly TE ddm1rdr6 versus ddm1',
                pCutoff = 0.01,
                FCcutoff = 0.5,
                transcriptPointSize = 1.5,
                transcriptLabSize = 0)


dev.off()


pdf("M poly TE ddm1rdr6 vs ddm1_Athila.pdf", width = 7, height = 6)

EnhancedVolcano(res_M_TE,
                lab = rownames(res_M_TE),
                x = 'log2FoldChange',
                y = 'pvalue',
                xlim = c(-12, 12),
                ylim = c(0, 6),
                colCustom = keyvals,
                title = 'M poly TE ddm1rdr6 versus ddm1',
                pCutoff = 0.01,
                FCcutoff = 0.5,
                transcriptPointSize = 1.5,
                transcriptLabSize = 0)


dev.off()

head(res_M_TE[order(res_M_TE$padj),],4)
write.table(res_M_TE, file="transleff_Mpoly_TE.xls", quote=FALSE, col.names = NA, sep="\t")


coldata <- DataFrame(assay=factor(rep(c("Tpoly","Total"), each=6)), condition=factor(rep(c("ddm1rdr6", "ddm1rdr6", "ddm1rdr6","ddm1","ddm1","ddm1")), levels=c("ddm1rdr6","ddm1")), row.names=c("Tpoly_ddm1rdr6_1", "Tpoly_ddm1rdr6_2", "Tpoly_ddm1rdr6_3", "Tpoly_ddm1_1", "Tpoly_ddm1_2", "Tpoly_ddm1_3", "Total_ddm1rdr6_1", "Total_ddm1rdr6_2", "Total_ddm1rdr6_3", "Total_ddm1_1", "Total_ddm1_2", "Total_ddm1_3"))

countDFeByg <- read.delim("unscaled_Tpoly_gene_final.txt", header=TRUE, sep="\t", row.names=1)

dds_T_gene <- DESeqDataSetFromMatrix(countData=countDFeByg, colData = coldata, design = ~ assay + condition + assay:condition)
dds_T_gene <- DESeq(dds_T_gene, test="LRT", reduced = ~ assay + condition)
res_T_gene <- DESeq2::results(dds_T_gene)


png("Tpoly gene ddm1rdr6 vs ddm1.png", width = 7, height = 6, units = 'in', res = 300)

EnhancedVolcano(res_T_gene,
                lab = rownames(res_T_gene),
                x = 'log2FoldChange',
                y = 'pvalue',
                xlim = c(-12, 12),
                ylim = c(0, 6),
                col=c('grey30','grey30','grey30','red2'),
                title = 'T poly gene ddm1rdr6 versus ddm1',
                pCutoff = 0.01,
                FCcutoff = 0.5,
                transcriptPointSize = 1.5,
                transcriptLabSize = 0)

dev.off()


pdf("Tpoly gene ddm1rdr6 vs ddm1.pdf", width = 7, height = 6)

EnhancedVolcano(res_T_gene,
                lab = rownames(res_T_gene),
                x = 'log2FoldChange',
                y = 'pvalue',
                xlim = c(-12, 12),
                ylim = c(0, 6),
                col=c('grey30','grey30','grey30','red2'),
                title = 'T poly gene ddm1rdr6 versus ddm1',
                pCutoff = 0.01,
                FCcutoff = 0.5,
                transcriptPointSize = 1.5,
                transcriptLabSize = 0)

dev.off()

head(res_T_gene[order(res_T_gene$padj),],4)
write.table(res_T_gene, file="transleff_Tpoly_gene.xls", quote=FALSE, col.names = NA, sep="\t")



countDFeByg <- read.delim("unscaled_Tpoly_TE_gene_final.txt", header=TRUE, sep="\t", row.names=1)

dds_T_TE <- DESeqDataSetFromMatrix(countData=countDFeByg, colData = coldata, design = ~ assay + condition + assay:condition)
dds_T_TE <- DESeq(dds_T_TE, test="LRT", reduced = ~ assay + condition)
res_T_TE <- DESeq2::results(dds_T_TE)


athila_Tpoly <- c('AT5G28892', 'AT1G37867', 'AT2G10180', 'AT4G06484', 'AT4G06735', 'AT5G32197', 'AT5G33255')


keyvals <- rep('grey30', nrow(res_T_TE))

names(keyvals) <- rep('Non', nrow(res_T_TE))

keyvals[which((res_T_TE$log2FoldChange > 0.5 & res_T_TE$pvalue < 0.01) | (res_T_TE$log2FoldChange < -0.5 & res_T_TE$pvalue < 0.01))] <- 'red2'

names(keyvals)[which((res_T_TE$log2FoldChange > 0.5 & res_T_TE$pvalue < 0.01) | (res_T_TE$log2FoldChange < -0.5 & res_T_TE$pvalue < 0.01))] <- 'Significant'


keyvals[which(rownames(res_T_TE) %in% athila_Tpoly)] <- 'blue'

names(keyvals)[which(rownames(res_T_TE) %in% athila_Tpoly)] <- 'ATHILA'


png("Tpoly TE ddm1rdr6 vs ddm1_Athila.png", width = 7, height = 6, units = 'in', res = 300)

EnhancedVolcano(res_T_TE,
                lab = rownames(res_T_TE),
                x = 'log2FoldChange',
                y = 'pvalue',
                xlim = c(-12, 12),
                ylim = c(0, 6),
                title = 'T poly TE ddm1rdr6 versus ddm1',
                pCutoff = 0.01,
                FCcutoff = 0.5,
                colCustom = keyvals,
                transcriptPointSize = 1.5,
                transcriptLabSize = 0)

dev.off()

pdf("Tpoly TE ddm1rdr6 vs ddm1_Athila.pdf", width = 7, height = 6)

EnhancedVolcano(res_T_TE,
                lab = rownames(res_T_TE),
                x = 'log2FoldChange',
                y = 'pvalue',
                xlim = c(-12, 12),
                ylim = c(0, 6),
                title = 'T poly TE ddm1rdr6 versus ddm1',
                pCutoff = 0.01,
                FCcutoff = 0.5,
                colCustom = keyvals,
                transcriptPointSize = 1.5,
                transcriptLabSize = 0)

dev.off()